(function(PLUGIN_ID) {
	'use strict';
	garoon.plugin.getConfig(PLUGIN_ID);

	// カスタムフィールドキー
	const customFieldKey = 'jp.co.cybozu.schedule.custom';


	/**
	 * スケジュール登録・変更時、カスタム項目のテキストボックスを追加する
	 * garoon側で Thenableオブジェクトを返すことが許可されていないので 同期関数として記述する
	 */
	garoon.events.on(
		['schedule.event.create.show', 'schedule.event.edit.show'], (event) => {
			return getCustomFields().then((customFields) => {
				const header = garoon.schedule.event.getHeaderSpaceElement();
				const customTable = document.createElement('table');
				header.appendChild(customTable);
				customTable.className = 'std_form';

				// 顧客名を追加
				const tr1 = document.createElement('tr');
				const th1 = document.createElement('th');
				tr1.appendChild(th1);
				th1.innerText = 'Front Agent\n顧客名';
				const td1 = document.createElement('td');
				tr1.appendChild(td1);
				const customerNameInput = document.createElement('input');
				td1.appendChild(customerNameInput);
				customerNameInput.type = 'text';
				customerNameInput.className = 'customer-name';
				customerNameInput.value = customFields.customer_name;

				// 会社名を追加
				const tr2 = document.createElement('tr');
				const th2 = document.createElement('th');
				tr2.appendChild(th2);
				th2.innerText = 'Front Agent\n会社名';
				const td2 = document.createElement('td');
				tr2.appendChild(td2);
				const customerCompanyInput = document.createElement('input');
				td2.appendChild(customerCompanyInput);
				customerCompanyInput.type = 'text';
				customerCompanyInput.className = 'customer-company';
				customerCompanyInput.value = customFields.customer_company;

				// bot入室URLを追加
				const tr3 = document.createElement('tr');
				const th3 = document.createElement('th');
				tr3.appendChild(th3);
				th3.innerText = 'Front Agent\nWeb会議URL';
				const td3 = document.createElement('td');
				tr3.appendChild(td3);
				customTable.appendChild(tr1);
				customTable.appendChild(tr2);
				customTable.appendChild(tr3);
				const joinUrlInput = document.createElement('input');
				td3.appendChild(joinUrlInput);
				joinUrlInput.type = 'text';
				joinUrlInput.className = 'join-url';
				joinUrlInput.value = customFields.join_url;

				console.info('カスタム項目追加完了');
				return event;
			});
		});


	/**
	 * 登録、変更画面の保存時に、テキストボックスの内容をカスタム項目に保存
	 */
	garoon.events.on(
		['schedule.event.create.submit', 'schedule.event.edit.submit'], async(event) => {
			const customerName = document.querySelector('.customer-name').value.trim();
			const customerCompany = document.querySelector('.customer-company').value.trim();
			const joinUrl = document.querySelector('.join-url').value.trim();

			const validationErrorMessage = validateCustomFields(customerName, customerCompany, joinUrl);
			if (validationErrorMessage) {
				window.alert(validationErrorMessage);
				return null;
			}
			const data = {
				value: {
					customer_name: customerName,
					customer_company: customerCompany,
					join_url: joinUrl,
				}
			};
			await garoon.schedule.event.datastore.set(customFieldKey, data);
			console.info('保存完了');
			return event;
		});


	/**
	 * 詳細画面でカスタム項目の内容を表示
	 * garoon側で Thenableオブジェクトを返すことが許可されていないので 同期関数として記述する
	 */
	garoon.events.on(
		['schedule.event.detail.show'], (event) => {
			return getCustomFields().then((customFields) => {
				garoon.schedule.event.insertTableRow('bot入室URL',
					`${customFields.join_url}`, 'DATE_AND_TIME');
				garoon.schedule.event.insertTableRow('会社名',
					`${customFields.customer_company}`, 'DATE_AND_TIME');
				garoon.schedule.event.insertTableRow('顧客名',
					`${customFields.customer_name}`, 'DATE_AND_TIME');

				return event;
			})
		});


	/**
	 * カスタム項目を取得するメソッド　undefinedや未入力なら明示的に空文字を返す
	 * @returns { object }
	 */
	async function getCustomFields() {
		const customFields = await garoon.schedule.event.datastore.get(
			customFieldKey);
		const customerName = customFields ? customFields.value?.customer_name.trim() :
			'';
		const customerCompany = customFields ? customFields.value?.customer_company
			.trim() : '';
		const joinUrl = customFields ? customFields.value?.join_url.trim() : '';

		return {
			customer_name: customerName ? customerName : '',
			customer_company: customerCompany ? customerCompany : '',
			join_url: joinUrl ? joinUrl : '',
		};
	}

	/**
	 * バリデーションメッセージを作成する 問題ないときは空文字を返す。
	 * 顧客名、会社名 500文字、bot入室URLは1000文字以内、
   * botURLは'http://' か 'https://' かで始まる必要がある
	 * 
	 * @param {string} customerName 
	 * @param {string} customerCompany 
	 * @param {string} joinUrl 
	 * @returns 
	 */
	function validateCustomFields(customerName, customerCompany, joinUrl) {
		let msg = '';
		if (customerName.length > 500) {
			msg += `顧客名は 500 文字以内で入力してください。 顧客名文字数: ${customerName.length}\n`;
		}
		if (customerCompany.length > 500) {
			msg += `会社名は 500 文字以内で入力してください。 会社名文字数: ${customerCompany.length}\n`;
		}
		if (joinUrl.length > 1000) {
			msg += `bot入室URLは 1000 文字以内で入力してください。 bot入室URL: ${joinUrl.length}\n`;
		}

		const pattern = /^https?:\/\/.+$/;
		if (joinUrl.length !== 0 && !pattern.test(joinUrl)) {
			msg += `bot入室URLには 有効なURLを入力してください。\n`;
		}

		return msg;
	}

})($PLUGIN_ID);
